

    '*************************************************************
    '                                                            '
    '   Official website : www.atomose.fr                        '
    '   LibertyBasic 4.51 pro                                    '
    '   Tower Defense Re-Evolution  (all copyrights reserved)   '
    '   ( OPEN SOURCE CODE )                                     '
    '   Creat by Alexandre Lomuto (Atomose Studio)               '
    '   Musique "reset" par jaunter                              '
    '                                                            '
    '*************************************************************

    nomainwin
    on error goto [noSav]
    dir$ = "" : file$ = "data.txt"
    if fileExist(dir$,file$) = 1 then loaded = 1 : continuer = 1 : gosub [input]
    if pass$ = "1" then wait
    [noSav]
    pass$ = "1" : gosub [print]
    Version$ = "3.7" : TIMERBOUCLE = 50 : version = 1

    [INITIAL]
    bruitage = 0
    WindowWidth=620 : WindowHeight=410 : UpperLeftX=int((DisplayWidth-WindowWidth)/2) : UpperLeftY=int((DisplayHeight-WindowHeight)/2)
    bmpbutton #ini.1, "data\fr.bmp", [fr], UL, 15,10
    bmpbutton #ini.2, "data\eng.bmp", [eng], UL, 45,10
    if continuer = 0 and version = 1 then button #ini.a1, "COMMENCER", [ini0], UL, 215, 150, 200,40
    if continuer = 1 and version = 1 then button #ini.a1, "CONTINUER", [ini0], UL, 215, 150, 200,40
    if version = 1 then button #ini.a2, "SITE WEB", [site], UL, 215, 200, 200,40
    if version = 1 then button #ini.a2, "A PROPOS", [about], UL, 215, 270, 200,40
    if continuer = 0 and version = 2 then button #ini.a1, "START GAME", [ini0], UL, 215, 150, 200,40
    if continuer = 1 and version = 2 then button #ini.a1, "LOAD GAME", [ini0], UL, 215, 150, 200,40
    if version = 2 then button #ini.a2, "WEB SITE", [site], UL, 215, 200, 200,40
    if version = 2 then button #ini.a2, "ABOUT", [about], UL, 215, 270, 200,40
    graphicbox #ini.main, 0, 0, WindowWidth, WindowHeight
    open "Tower Defense by Atomose Studio " for window_nf as #ini
    #ini, "trapclose [quit3]"
    #ini.main, "down; fill white"
    #ini, "font Cascadia_Code 12"
    #ini.main, "font Cascadia_Code 20 bold; color black; backcolor white"
    #ini.main, "place 210 80 ;\"; "TOWER DEFENSE"
    #ini.main, "font Cascadia_Code 8; color black; backcolor white"
    #ini.main, "place 520 360 ;\"; "Version ";Version$
    #ini.main, "flush"
    wait

    [site]
    run "explorer.exe https://www.atomose.fr/la-bibliotheque"
    wait
    [about]
    if Setting = 1 then close #about
    Setting = 1
    BackgroundColor$ = "white" : ForegroundColor$ = "black"
    WindowWidth = 260 : WindowHeight = 150
    UpperLeftX=int((DisplayWidth-WindowWidth)/2) : UpperLeftY=int((DisplayHeight-WindowHeight)/2)
    graphicbox #about.map, 0, 0, WindowWidth, WindowHeight
    open "A propos" for window_nf as #about
    #about.map, "font Cascadia_Code 9; color black; backcolor white"
    #about.map, "place 20 20 ;\"; "Tower Defense\Atomose Studio  2021-2025\LibertyBasic 4.51 Pro\\Ce jeu est OPEN SOURCE\(code .bas dans le dossier)"
    wait

    [quit3]
    close #ini : pass$ = "0" : gosub [print]
    if Setting = 1 then close #about
    end

    [fr]
    version = 1 : close #ini : goto [INITIAL]
    [eng]
    version = 2 : close #ini : goto [INITIAL]

    [ini0]
    close #ini
    if loaded = 1 and life >0 then goto [loaded]
    [ini]
    global towers, life, Nvague, gold, compteurBOSS, compteurSUPERboss, towerOLD
    Nvague = 1 : towers = 0 : life = 20 : gold = 100 : compteurBOSS = 4 : compteurSUPERboss = 14

    [rmk]
    TIMERBOUCLE = 50 : pause = 0 : mapCHOICE = mapCHOICE + 1 : if mapCHOICE > 4 then mapCHOICE = 1
    if mapCHOICE = 1 then goto [map1]
    if mapCHOICE = 2 then goto [map2]
    if mapCHOICE = 3 then goto [map3]
    if mapCHOICE = 4 then goto [map4]

    [map1]
    map$ = "";_
           "    ";_
           "           ";_
           "&ABCD          ";_
           "  EFGHIJKLMN ";_
           "          O  ";_
           "    aZYXW   P ";_
           "     b  VUTSRQ  ";_
           "  cde    ";_
           "     f  ";_
           " lkjihg  []";_
           " m           ";_
           "  nopqrstuvwxyz0  ";_
           "           1  ";_
           " =<;:98765432 ";_
           " >     ";_
           "?    ";_
           "@"
    goto [loaded]
    [map2]
    map$ = "৲";_
           "^^^         ";_
           " IJKLMNOPQRST ";_
           "   H        U";_
           "  G  jihg  V ";_
           "CDEF  k f W   ";_
           "B    l  e  X   ";_
           "&A     m  dcbaZY   ";_
           "    n       ";_
           "  opqrstu  ";_
           "      v ";_
           "@?>=<;:9 w   ";_
           "    8駵 x   ";_
           "   7 { y ";_
           "  6543210z    ";_
           "       ";_
           "    ";_
           ""
    goto [loaded]
    [map3]
    map$ = "";_
           "       ";_
           "        &ABC  ";_
           "  UTSRQ      D ";_
           " V  P       E   ";_
           "W  ONMLKJIHGF ";_
           "  X            ";_
           "Y      ";_
           " Z opqrst     ";_
           " a  n    u       ";_
           "  b  m  v    ";_
           " c  l  w  :;<=>?@";_
           "d  k  zyx   9";_
           " e  j  0  8    ";_
           "fghi 1234567 ";_
           "        ";_
           "       ";_
           ""
    goto [loaded]
    [map4]
    map$ = "";_
           "        ";_
           "@?>=<;  dcbaZYXWV  ";_
           " : e     U   ";_
           "   9  f   T   ";_
           "  678   g      S   ";_
           " 5     hijk    R  ";_
           " 4     l    Q ";_
           "3     m  P";_
           " 2    n  O   ";_
           "  1    o   N ";_
           " 0      p    M   ";_
           "  zyxwvutsrq   L ";_
           "             K  ";_
           "  BCDEFGHIJ  ";_
           "    &A     ";_
           "    ";_
           ""


  '  map$ = "";_     90 posibilits de marche
  '         "                             ";_     if v>=36 and v<=126 then index = v-36 : pathX(index)=x : pathY(index)=y
  '         "    $%&'()*+,-./01234567     ";_
  '         "                       8     ";_
  '         "  hijklmnopqrstuvwxy   9     ";_
  '         "  g                z   :     ";_
  '         "  f                {   ;     ";_
  '         "  e                |   <     ";_
  '         "  d                }   =     ";_
  '         "  c                ~   >     ";_
  '         "  b                    ?     ";_
  '         "  a                    @     ";_
  '         "  `                    A     ";_
  '         "  _                    B     ";_
  '         "  ^                    C     ";_
  '         "  ]                    D     ";_
  '         "  \                    E     ";_
  '         "  [ZYXWVUTSRQPONMLKJIHGF     ";_
  '         "                             ";_
  '         ""


    [loaded]
    WindowWidth=620 : WindowHeight=410 : UpperLeftX=int((DisplayWidth-WindowWidth)/2) : UpperLeftY=int((DisplayHeight-WindowHeight)/2)
    maxTowers = 1000 : UPGRADE = 0 : GameActivation = 1
    global txt1$, txt2$, txt3$, version, map$, maxTowers, UPGRADE, pause
    dim pathX(69), pathY(69), towerX(maxTowers), towerY(maxTowers), towerSpeed(maxTowers), towerRange(maxTowers), towerDamage(maxTowers), towerTime(maxTowers), bulletX(maxTowers), bulletY(maxTowers)

    if version = 1 then txt1$ = "Attaque : " :txt2$ = "Porte : " : txt3$ = "Vitsse : "
    if version = 2 then txt1$ = "Attack : " :txt2$ = "Range : " : txt3$ = "Speed : "

    for x = 1 to 22
        for y = 1 to 18
            v = asc(mid$(map$, x+(y-1)*22, 1))
            if v>=48 and v<=64 then index=v-47+52 : pathX(index)=x : pathY(index)=y '3
            if v>=65 and v<=90 then index=v-64 : pathX(index)=x : pathY(index)=y '1
            if v>=97 and v<=122 then index=v-96+26 : pathX(index)=x : pathY(index)=y '2
        next y
    next x

    sprites$ = "nuage1 nuage2 tower1 arbre arbre2 rocher grass road road2 road3 road4 road5 road6 door door2 door3 trou creep creep2 creep3 towerA towerB towerC towerD towerE towerF towerG towerH towerI towerJ bullet eau1 eau2 eau3 eau4 eau5 eau6 eau7 eau8 eau9 eau10 eau11 eau12"
    for s = 1 to 43
        loadbmp word$(sprites$,s), "data\"+word$(sprites$,s)+".bmp"
    next

    if version = 1 then button #td.b4, "NOUVELLE PARTIE", [RESET], UL, 460, 305,145,25
    if version = 2 then button #td.b4, "NEW GAME", [RESET], UL, 460, 305,145,25
    bmpbutton #td.b5, "data\aide.bmp", [help], UL, 521,345
    bmpbutton #td.b6, "data\son.bmp", [iniMUSIC], UL, 465,345
    bmpbutton #td.b14, "data\son1.bmp", [iniMUSIC], UL, 465,345
    bmpbutton #td.b7, "data\son2.bmp", [bruitage], UL, 493,345
    bmpbutton #td.b8, "data\son3.bmp", [bruitage], UL, 493,345

    bmpbutton #td.b10, "data\play.bmp", [pause], UL, 475,22
    bmpbutton #td.b13, "data\pause.bmp", [pause], UL, 475,22
    bmpbutton #td.b11, "data\speed1.bmp", [vitesse], UL, 505,22
    bmpbutton #td.b12, "data\speed2.bmp", [vitesse], UL, 505,22

    bmpbutton #td.b9, "data\aide2.bmp", [w], UL, 477,107

    statictext #td.vrs, "Vrs. ";Version$ , 553, 350, 100, 15
    graphicbox #td.main, 10, 10, 442, 362
    graphicbox #td.main2, 460, 10, 145, 240
    open "Tower Defense by Atomose Studio " for window_nf as #td
    #td "trapclose [quit]"
    #td.main "down"
    print #td.b7, "hide"
    print #td.b12, "hide"
    print #td.b13, "hide"
    print #td.b9, "disable"

    if music = 1 then #td.b14, "hide"
    if music = 0 then #td.b6, "hide"

    handle = hwnd(#td)
    hTip=CreateTooltip(handle)
    if version = 1 then
        Call AddToolTip Hwnd(#td.b4), hTip , "Efface la partie en cours pour en refaire une nouvelle"
        Call AddToolTip Hwnd(#td.b5), hTip , "Page d'aide si vous ne comprenez pas le jeu"
        Call AddToolTip Hwnd(#td.b6), hTip , "Active ou dsactive la musique du jeu"
        Call AddToolTip Hwnd(#td.b7), hTip , "Active ou dsactive les bruitages du jeu"
    end if
    if version = 2 then
        Call AddToolTip Hwnd(#td.b4), hTip , "Delete the current game to start a new one"
        Call AddToolTip Hwnd(#td.b5), hTip , "Help page if you don't understand the game"
        Call AddToolTip Hwnd(#td.b6), hTip , "Enable or disable game music"
        Call AddToolTip Hwnd(#td.b7), hTip , "Enable or disable game songs"
    end if

    for x = 1 to 22
        for y = 1 to 18
            char$ = mid$(map$, x+(y-1)*22, 1)
            #td.main "place ";(x-1)*20;" ";(y-1)*20
            select case char$
                case " ","!","#","$","%","(",")","*","+",""
                    #td.main "drawbmp grass"
                case ""
                    #td.main "drawbmp eau1"
                case "^"
                    #td.main "drawbmp eau2"
                case ""
                    #td.main "drawbmp eau3"
                case ""
                    #td.main "drawbmp eau4"
                case ""
                    #td.main "drawbmp eau5"
                case "}"
                    #td.main "drawbmp eau6"
                case "{"
                    #td.main "drawbmp eau7"
                case ""
                    #td.main "drawbmp eau8"
                case ""
                    #td.main "drawbmp eau9"
                case "["
                    #td.main "drawbmp eau10"
                case "]"
                    #td.main "drawbmp eau11"
                case ""
                    #td.main "drawbmp eau12"
                case ""
                    #td.main "drawbmp arbre"
                case ""
                    #td.main "drawbmp arbre2"
                case ""
                    #td.main "drawbmp rocher"
                case "&"
                    #td.main "drawbmp trou"
                end select
            if mapCHOICE = 1 then
                select case char$
                case "O","P","b","f","m","1",">","?"
                    #td.main "drawbmp road"
                case "A","B","C","F","G","H","I","J","K","L","M","U","T","S","R","Z","Y","X","d","k","j","i","h","o","p","q","r","s","t","u","v","w","x","y","z","7","6","5","4","3","<",";",":","9","8"
                    #td.main "drawbmp road2"
                case "a","l","="
                    #td.main "drawbmp road3"
                case "D","N","e","W","0"
                    #td.main "drawbmp road4"
                case "Q","g","2"
                    #td.main "drawbmp road5"
                case "C","E","n","c","V"
                    #td.main "drawbmp road6"
                case "@"
                    #td.main "drawbmp door"
                end select
            end if
            if mapCHOICE = 2 then
                select case char$
                case "B","G","H","U","V","W","X","e","f","k","l","m","n","v","w","x","y","7","8"
                    #td.main "drawbmp road"
                case "J","K","L","M","N","O","P","Q","R","S","D","E","c","b","a","Z","p","q","r","s","t","i","h","5","4","3","2","1","0","?",">","=","<",";",":"
                    #td.main "drawbmp road2"
                case "C","I","j"
                    #td.main "drawbmp road3"
                case "T","g","u","9"
                    #td.main "drawbmp road4"
                case "A","F","Y","z"
                    #td.main "drawbmp road5"
                case "d","o","6"
                    #td.main "drawbmp road6"
                case "@"
                    #td.main "drawbmp door2"
                end select
            end if
            if mapCHOICE = 3 then
                select case char$
                case "D","E","P","V","W","X","Y","Z","a","b","c","d","e","j","k","l","m","n","u","v","w","0","8","9"
                    #td.main "drawbmp road"
                case "A","B","N","M","L","K","J","I","H","G","T","S","R","g","h","p","q","r","y","s","4","5","6","=",">","?","2",";","<","3"
                    #td.main "drawbmp road2"
                case "U","o","z",":"
                    #td.main "drawbmp road3"
                case "C","Q","t"
                    #td.main "drawbmp road4"
                case "i","x","F","7"
                    #td.main "drawbmp road5"
                case "O","f","1"
                    #td.main "drawbmp road6"
                case "@"
                    #td.main "drawbmp door3"
                end select
            end if
            if mapCHOICE = 4 then
                select case char$
                case "K","L","M","N","O","P","Q","R","S","T","U","e","f","g","l","m","n","o","p","0","1","2","3","4","5","9",":"
                    #td.main "drawbmp road"
                case "7","y","x","w","v","u","t","s","r","i","j","c","b","a","Z","Y","X","W","C","D","E","I","E","F","G","H","=",">","?","<"
                    #td.main "drawbmp road2"
                case "B","d","6"
                    #td.main "drawbmp road3"
                case "V","k",";"
                    #td.main "drawbmp road4"
                case "A","J","q","8"
                    #td.main "drawbmp road5"
                case "h","z"
                    #td.main "drawbmp road6"
                case "@"
                    #td.main "drawbmp door2"
                end select
            end if
        next y
    next x

    call RemooveOldTower x, y
    #td, "font Cascadia_Code 7"
    print #td.b4, "!font Cascadia_Code 9"
    #td.main "getbmp background 0 0 442 362; background background"

    f$ = chr$(34) + "data\laser.wav" + chr$(34)
    r$ = mcisend$("open " + f$ + " type waveaudio alias laser")
    f$ = chr$(34) + "data\music.mp3" + chr$(34)
    r$ = mcisend$("open " + f$ + " type mpegvideo alias music")

    nuageX1 = int(rnd(1)*500+400) : nuageX2 = int(rnd(1)*500+400) : nuageX3 = int(rnd(1)*500+400)
    nuageY1 = int(rnd(1)*300+10) : nuageY2 = int(rnd(1)*300+10) : nuageY2 = int(rnd(1)*300+10)
    #td.main "addsprite nuage1 nuage1 nuage1; spriteXY nuage1 ";nuageX1;" ";nuageY1 : #td.main "spritevisible nuage1 on; spritetofront nuage1"
    #td.main "addsprite nuage2 nuage2 nuage2; spriteXY nuage2 ";nuageX2;" ";nuageY2 : #td.main "spritevisible nuage2 on; spritetofront nuage2"
    #td.main "addsprite nuage3 nuage2 nuage2; spriteXY nuage3 ";nuageX3;" ";nuageY3 : #td.main "spritevisible nuage3 on; spritetofront nuage3"

    [nextLevel]
    global creeps, maxCreeps, vitesseSprite, infoTOWER, infoTOWERx, infoTOWERy, infoTOWERgold, bruitage, ActivElite, ActivKing, NumberSprite, UPGRADE
    vitesseSprite = int(rnd(1)*(30)+30) : creeps = 100 : UPGRADE = 0
    dim creepPosX(creeps), creepPosY(creeps), creepHealth(creeps), creepSpeed(creeps), creepTime(creeps)
    ActivElite = 0 : ActivKing = 0
    NumberSprite = int(rnd(1)*50+50) : maxCreeps = NumberSprite
    for c = 1 to NumberSprite
        if c > 1 then
            #td.main "addsprite creep";c;" creep; spriteXY creep";c;" ";-22;" ";-20;"; spritevisible creep";c;" on"
            creepHealth(c)= int(rnd(1)*(15*Nvague)+Nvague) : creepSpeed(c)=vitesseSprite : creepTime(c)=150*c
        else
            if compteurBOSS > 0 and compteurSUPERboss > 0 then
                #td.main "addsprite creep";c;" creep; spriteXY creep";c;" ";-22;" ";-20;"; spritevisible creep";c;" on"
                creepHealth(c)= int(rnd(1)*(25*Nvague)+Nvague) : creepSpeed(c)=vitesseSprite : creepTime(c)=150*c
                if version = 1 then txtwave$ = "Ennemis basique"
                if version = 2 then txtwave$ = "Basic ennemis"
            end if
            if compteurSUPERboss > 0 and compteurBOSS = 0 then
                #td.main "addsprite creep";c;" creep2; spriteXY creep";c;" ";-22;" ";-20;"; spritevisible creep";c;" on"
                creepHealth(c)= int(175*Nvague) : creepSpeed(c)=vitesseSprite: creepTime(c)=150*c
                ActivElite = 1
                txtwave$ = "Elite : "
            end if
            if compteurBOSS > 0 and compteurSUPERboss = 0 then
                #td.main "addsprite creep";c;" creep3; spriteXY creep";c;" ";-22;" ";-20;"; spritevisible creep";c;" on"
                creepHealth(c)= int(1000*Nvague) : creepSpeed(c)=10 : creepTime(c)=150*c
                ActivKing = 1
                if version = 1 then txtwave$ = "Roi : "
                if version = 2 then txtwave$ = "King : "
            end if
        end if
    next c

    call RemooveOldTower x, y
    #td.main "addsprite bullet bullet; spriteXY bullet ";-10;" ";-10
    #td.main "when leftButtonDown click; when rightButtonDown click2"
    #td.main2 "down; fill white; setfocus; color black; font ink_free 10; when leftButtonDown click3"
    goto [boucle]

    [vitesse]
    if pause = 1 then wait
    if TIMERBOUCLE = 0 then TIMERBOUCLE = 50 : print #td.b12, "hide" : print #td.b11, "show" : goto [boucle]
    if TIMERBOUCLE = 50 then TIMERBOUCLE = 0 : bruitage = 0 : print #td.b11, "hide" : print #td.b12, "show" : print #td.b7, "hide" : print #td.b8, "show" : bruitage = 0 : goto [boucle]
    goto [boucle]

    [pause]
    if pause = 1 then pause = 0 : print #td.b10, "show" : print #td.b13, "hide" : goto [boucle]
    if pause = 0 then
        pause = 1 : print #td.b13, "show" : print #td.b10, "hide"
        ' supprime le backcolor pour texte transparent
        hGBox = hwnd(#td.main)
        CallDLL #user32, "GetDC",_
        hGBox As ulong,_  'handle of graphicbox
        gDC As ulong      'device context
        CallDLL #gdi32, "SetBkMode",_
        gDC As ulong,_          'handle of graphicbox
        _TRANSPARENT As long,_  'flag for transparent background
        result As long          'previous bkmode
        CallDLL#user32,"ReleaseDC",_
        hGBox As ulong,_    'graphicbox handle
        gDC As ulong,_      'device context
        result As long
        #td.main "font Cascadia_Code 24 bold; color black"
        if version = 1 then #td.main "place 110 200 ;\"; "JEU EN PAUSE"
        if version = 2 then #td.main "place 120 200 ;\"; "PAUSED GAME"
        wait
    end if


    [help]
    if help = 1 then close #help
    help = 1
    global txt1$, txt2$, txt3$
    if version = 1 then txt1$ = "Attaque : " :txt2$ = "Porte : " : txt3$ = "Vitsse : "
    if version = 2 then txt1$ = "Attack : " :txt2$ = "Range : " : txt3$ = "Speed : "
    graphicbox #help.main, 7, 7, 598, 365
    bmpbutton #help.1, "data\fr.bmp", [fr2], UL, 530,332
    bmpbutton #help.2, "data\eng.bmp", [eng2], UL, 560,332
    open "Tower Defense by Atomose Studio " for window_nf as #help
    #help, "trapclose [help2]"
    #help.main "down; fill white; font Cascadia_Code 9 italic; color black"
    if version = 1 then
        #help.main "place 17 25 ;\"; "-  But du jeu : \Vous devez empcher l'ennemi de rentrer par le pont. Pour cela, vous  devrez tuer \chaque ennemis a l'aide de tours qu'il faudra construire au  bord de la route.\\-  Les ennemis :\Ils sortent du trou et se dirigent droit vers le pont! Ils ne peuvent que marcher \sur la route. Dans chaque vague il y a 50 ennemis. Ils deviennent de plus en plus \fort  chaque vague. Une fois tu, ils vous donnerons de l'argent.\\-  Les tours : \Elles sont votre seul moyen de dfense. Pour les construire il suffit de cliquer \sur une case disponible. Pour les amliorer il suffit de cliquer sur \une tour existante et d'avoir asser d'argent. \(Prix : 5 - 10 - 20 - 40 - 80 - 160 - 320 - 640 - 1280 - 2560)\\Vous pouvez revendre les tours en cliquant droit sur la tour, puis en appuyant \sur l'icne de la fentre droite reprsentant la tour selectionne."
        #help.main "place 17 315 ;\"; "Tower Defense Re-evolution Version d'essai\Cr par Atomose Studio  avec Liberty Basic 4.51 pro\Musique : 'Reset' de Jaunter"
    end if
    if version = 2 then
        #help.main "place 17 25 ;\"; "- Object of the game: \You must prevent the enemy from entering via the bridge. To do this, you will \have to kill each enemy with the help of towers that you will have to build on \the side of the road.\\- The enemies:\They come out of the hole and head straight for the bridge! They can only walk \on the road. In each wave there are 50 enemies. They get stronger and stronger \with each wave. Once killed, they will give you money.\\- Towers: \They are your only defense. To build them just click on an available square. To \upgrade them just click on an existing tower and have enough money. \(Prices : 5 - 10 - 20 - 40 - 80 - 160 - 320 - 640 - 1280 - 2560)\\You can resell towers by right-clicking on the tower, then pressing the icon in \the right window representing the selected tower."
        #help.main "place 17 315 ;\"; "Tower Defense Re-evolution lite version\Created by Atomose Studio  with Liberty Basic 4.51 pro\Music: 'Reset' by Jaunter"
    end if
    #td.main "flush" : #help.main "flush"
    if version = 1 then print #td.b4, "NOUVELLE PARTIE"
    if version = 2 then print #td.b4, "NEW GAME"
    handle = hwnd(#td)
    hTip=CreateTooltip(handle)
    if version = 1 then
        Call AddToolTip Hwnd(#td.b4), hTip , "Efface la partie en cours pour en refaire une nouvelle"
        Call AddToolTip Hwnd(#td.b5), hTip , "Page d'aide si vous ne comprenez pas le jeu"
        Call AddToolTip Hwnd(#td.b6), hTip , "Active ou dsactive la musique du jeu"
    end if
    if version = 2 then
        Call AddToolTip Hwnd(#td.b4), hTip , "Delete the current game to start a new one"
        Call AddToolTip Hwnd(#td.b5), hTip , "Help page if you don't understand the game"
        Call AddToolTip Hwnd(#td.b6), hTip , "Enable or disable game music"
    end if
    wait
    [help2]
    close #help : help = 0
    if pause = 1 then
        #td.main "drawsprites"
        #td.main "font Cascadia_Code 24 bold; color black"
        if version = 1 then #td.main "place 110 200 ;\"; "JEU EN PAUSE"
        if version = 2 then #td.main "place 120 200 ;\"; "PAUSED GAME"
        wait
    end if
    goto [boucle]
    [fr2]
    version = 1 : goto [help]
    [eng2]
    version = 2 : goto [help]

    [print]
    global map$ 
    open "data.txt" for output as #secu
    print #secu, pass$
    print #secu, life
    print #secu, Nvague
    print #secu, gold
    print #secu, compteurBOSS
    print #secu, compteurSUPERboss
    print #secu, towers
    print #secu, map$
    print #secu, mapCHOICE
    close #secu
    if GameActivation = 1 and GameOver = 0 then call Sleep 50 : goto [boucle]
    return

    [input]
    open "data.txt" for input as #secu
    input #secu, pass$
    input #secu, life
    input #secu, Nvague
    input #secu, gold
    input #secu, compteurBOSS
    input #secu, compteurSUPERboss
    input #secu, towers
    input #secu, map$
    input #secu, mapCHOICE
    close #secu
    return

    [RESET]
    close #td : call Sleep 50 : goto [ini]

    [quit]
    GameActivation = 0
    r$ = mcisend$("pause music")
    pass$ = "0" : if noSAVE = 0 then gosub [print]
    if help = 1 then close #help
    if GameOver = 0 then close #td
    if Setting = 1 then close #about
    end

    [iniMUSIC]
    if music = 0 then activation = 0 : music = 1 : r$  =mcisend$("set music time format ms") : r$ = mcisend$("status music length") : #td.b14, "hide" : #td.b6, "show" : looplength=val(r$) : r$ = mcisend$("play music from 0 repeat") : goto [boucle]
    if music = 1 then activation = 0 : music = 0 : r$ = mcisend$("pause music") : #td.b6, "hide" : #td.b14, "show" : goto [boucle]

    [bruitage]
    actionBUTTON = 1
    if bruitage = 0 and TIMERBOUCLE > 0 then print #td.b8, "hide" : print #td.b7, "show" : bruitage = 1 : goto [boucle]
    if bruitage = 1 then print #td.b7, "hide" : print #td.b8, "show" : bruitage = 0 : goto [boucle]

    [boucle]
    on error goto [ERRORnotif]
    #td.main "discard"
    scan
    call advanceCreeps

    if version = 1 then #td.main2 "font Cascadia_Code 8; place 15 60 ;\"; "Vague n ";Nvague;" (";NumberSprite;")   \\\   : "; life;"   \   : "; gold;"       "
    if version = 2 then #td.main2 "font Cascadia_Code 8; place 15 60 ;\"; "Wave n ";Nvague;" (";NumberSprite;")   \\\   : "; life;"   \   : "; gold;"       "
    if creepHealth(1) < 0 then creepHealth(1) = 0
    if txtwave$ = "Ennemis basique" or txtwave$ = "Basic ennemis" then print #td.main2, "place 15 75 ;\"; txtwave$;"  "
    if txtwave$ = "Elite : " or txtwave$ = "Roi : " or txtwave$ = "King : " then print #td.main2, "place 15 75 ;\"; txtwave$ ;" "; creepHealth(1);"    "

    if NumberSprite = 0 then
        Nvague = Nvague + 1 : compteurBOSS = compteurBOSS -1 : compteurSUPERboss = compteurSUPERboss - 1 : secuBOSS = 0
        if compteurBOSS <0 then compteurBOSS = 4
        if compteurSUPERboss = 0 then compteurBOSS =5
        if compteurSUPERboss <0 then compteurSUPERboss = 14
        gold = gold + 10 + int(Nvague-1) : goto [nextLevel]
    end if

    nuageX1 = nuageX1 - 1.25 : if nuageX1 < -100 then nuageX1 = int(rnd(1)*500+400) : nuageY1 = int(rnd(1)*300+10)
    #td.main "spriteXY nuage1 ";nuageX1;" ";nuageY1 : #td.main "spritevisible nuage1 on; spritetofront nuage1"
    nuageX2 = nuageX2 - 0.75 : if nuageX2 < -100 then nuageX2 = int(rnd(1)*500+400) : nuageY2 = int(rnd(1)*300+10)
    #td.main "spriteXY nuage2 ";nuageX2;" ";nuageY2 : #td.main "spritevisible nuage2 on; spritetofront nuage2"
    nuageX3 = nuageX3 - 0.5 : if nuageX3 < -100 then nuageX3 = int(rnd(1)*500+400) : nuageY3 = int(rnd(1)*300+10)
    #td.main "spriteXY nuage3 ";nuageX3;" ";nuageY3 : #td.main "spritevisible nuage3 on; spritetofront nuage3"

    if life <=0 then
        close #td
        graphicbox #quit.main, 7, 7, 598, 365
        open "Tower Defense lite edition" for window_nf as #quit
        #quit, "trapclose [quit]"
        #quit.main "down; fill white; font ink_free 40 bold; color red"
        #quit.main "place 140 160 ;\"; "GAME OVER"
        #quit.main "font ink_free 8 italic bold; color black"
        if version = 1 then #quit.main "place 190 270 ;\"; "(Faudra mieux faire la prochaine fois)"
        if version = 2 then #quit.main "place 200 270 ;\"; "(Will have to do better next time)"
        #quit.main "flush"
        kill "data.txt" : noSAVE = 1 : GameOver = 1
        call Sleep 3000 : close #quit : goto [quit] : wait
    end if

    #td.main "drawsprites"
    call Sleep TIMERBOUCLE : goto [boucle]

    [ERRORnotif]
    call Sleep TIMERBOUCLE : goto [boucle]


    ' SUB ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


    sub click handle$, mx, my
        x = int(mx/20)+1  :  y = int(my/20)+1
        if pause = 0 and (mid$(map$, x+(y-1)*22, 1) = " " or mid$(map$, x+(y-1)*22, 1) = "" or mid$(map$, x+(y-1)*22, 1) = "" or mid$(map$, x+(y-1)*22, 1) = "" or mid$(map$, x+(y-1)*22, 1) = "") then infoTOWER = 0 : #td.main2 "place 10 165 ;\"; "                                      \                                      \                                       \                                       "
        if pause = 0 and mid$(map$, x+(y-1)*22, 1) = "," and gold >= 2560 then UPGRADE = 1 : map$=mid$(map$,1,x+(y-1)*22-1) ; "" ; mid$(map$, x+(y-1)*22+1) : #td.main "removesprite towerX";x;"Y";y : gold = gold - 2560 : call RemooveOldTower x, y
        if pause = 0 and mid$(map$, x+(y-1)*22, 1) = "+" and gold >= 1280 then UPGRADE = 1 : map$=mid$(map$,1,x+(y-1)*22-1) ; "," ; mid$(map$, x+(y-1)*22+1) : #td.main "removesprite towerX";x;"Y";y : gold = gold - 1280 : call RemooveOldTower x, y
        if pause = 0 and mid$(map$, x+(y-1)*22, 1) = "*" and gold >= 640 then UPGRADE = 1 : map$=mid$(map$,1,x+(y-1)*22-1) ; "+" ; mid$(map$, x+(y-1)*22+1) : #td.main "removesprite towerX";x;"Y";y : gold = gold - 640 : call RemooveOldTower x, y
        if pause = 0 and mid$(map$, x+(y-1)*22, 1) = ")" and gold >= 320 then UPGRADE = 1 : map$=mid$(map$,1,x+(y-1)*22-1) ; "*" ; mid$(map$, x+(y-1)*22+1) : #td.main "removesprite towerX";x;"Y";y : gold = gold - 320 : call RemooveOldTower x, y
        if pause = 0 and mid$(map$, x+(y-1)*22, 1) = "(" and gold >= 160 then UPGRADE = 1 : map$=mid$(map$,1,x+(y-1)*22-1) ; ")" ; mid$(map$, x+(y-1)*22+1) : #td.main "removesprite towerX";x;"Y";y : gold = gold - 160 : call RemooveOldTower x, y
        if pause = 0 and mid$(map$, x+(y-1)*22, 1) = "%" and gold >= 80 then UPGRADE = 1 : map$=mid$(map$,1,x+(y-1)*22-1) ; "(" ; mid$(map$, x+(y-1)*22+1) : #td.main "removesprite towerX";x;"Y";y : gold = gold - 80 : call RemooveOldTower x, y
        if pause = 0 and mid$(map$, x+(y-1)*22, 1) = "$" and gold >= 40 then UPGRADE = 1 : map$=mid$(map$,1,x+(y-1)*22-1) ; "%" ; mid$(map$, x+(y-1)*22+1) : #td.main "removesprite towerX";x;"Y";y : gold = gold - 40 : call RemooveOldTower x, y
        if pause = 0 and mid$(map$, x+(y-1)*22, 1) = "#" and gold >= 20 then UPGRADE = 1 : map$=mid$(map$,1,x+(y-1)*22-1) ; "$" ; mid$(map$, x+(y-1)*22+1) : #td.main "removesprite towerX";x;"Y";y : gold = gold - 20 : call RemooveOldTower x, y
        if pause = 0 and mid$(map$, x+(y-1)*22, 1) = "!" and gold >= 10 then UPGRADE = 1 : map$=mid$(map$,1,x+(y-1)*22-1) ; "#" ; mid$(map$, x+(y-1)*22+1) : #td.main "removesprite towerX";x;"Y";y : gold = gold - 10 : call RemooveOldTower x, y
        if pause = 0 and mid$(map$, x+(y-1)*22, 1) = " " and gold >= 5 then gold = gold - 5 : call placeTower1 x, y
    end sub

    sub click2 handle$, mx, my
        x = int(mx/20)+1  :  y = int(my/20)+1
        for a = 1 to towers
            if x = towerX(a) and y = towerY(a) and pause = 0 then
                select case mid$(map$, x+(y-1)*22, 1)
                    case "!"
                        SPEED = 4 : RANGE = 2 : DAMAGE = 10
                    case "#"
                        SPEED = 5 : RANGE = 2 : DAMAGE = 25
                    case "$"
                        SPEED = 5 : RANGE = 2 : DAMAGE = 50
                    case "%"
                        SPEED = 6 : RANGE = 2 : DAMAGE = 100
                    case "("
                        SPEED = 6 : RANGE = 3 : DAMAGE = 200
                    case ")"
                        SPEED = 7 : RANGE = 3 : DAMAGE = 400
                    case "*"
                        SPEED = 8 : RANGE = 3 : DAMAGE = 1000
                    case "+"
                        SPEED = 8 : RANGE = 3 : DAMAGE = 2000
                    case ","
                        SPEED = 9 : RANGE = 4 : DAMAGE = 4000
                    case ""
                        SPEED = 10 : RANGE = 4 : DAMAGE = 8000
                end select
                infoTOWER = 1 : infoTOWERgold = int(DAMAGE/2) : infoTOWERx = x : infoTOWERy = y : number = a
                #td.main2 "drawbmp tower1 10 155" : #td.main2 "font Cascadia_Code 8" : #td.main2 "place 40 163 ;\"; txt1$;DAMAGE;"     \";txt2$;RANGE;"    \";txt3$;SPEED;"     "
            end if
        next a
        if mid$(map$, x+(y-1)*22, 1) = " " or mid$(map$, x+(y-1)*22, 1) = "" or mid$(map$, x+(y-1)*22, 1) = "" or mid$(map$, x+(y-1)*22, 1) = "" or mid$(map$, x+(y-1)*22, 1) = "" then infoTOWER = 0 : #td.main2 "place 10 158 ;\"; "                                      \                                      \                                       \                                       "
    end sub

    sub click3 handle$, mx, my
        mXX = MouseX : mYY = MouseY
        if pause = 0 and infoTOWER = 1 and mXX > 10 and mXX < 30 and mYY >150 and mYY < 190 then
            if version = 1 then demande$ = "Voulez vous revendre cette tour pour ";infoTOWERgold;" pices d'or ?"
            if version = 2 then demande$ = "Do you want to remoove this tower for ";infoTOWERgold;" gold ?"
            confirm demande$;text$
            if text$ = "no" then infoTOWER = 0 : #td.main2 "place 10 158 ;\"; "                                        \                                        \                                         \                                         \                                             " : infoTOWER = 0 : goto [boucle]
            gold = gold + infoTOWERgold : infoTOWER = 0
            #td.main2 "place 10 158 ;\"; "                                       \                                       \                                        \                                             "
            #td.main "removesprite towerX";infoTOWERx;"Y";infoTOWERy
            #td.main "removesprite bulletX";infoTOWERx;"Y";infoTOWERy
            towers=towers-1 : map$=mid$(map$,1,infoTOWERx+(infoTOWERy-1)*22-1) ; " " ; mid$(map$, infoTOWERx+(infoTOWERy-1)*22+1)
        end if
    end sub

    sub advanceCreeps
        for thisCreep = 1 to maxCreeps
            if creepHealth(thisCreep)>0 then
                creepTime(thisCreep)=creepTime(thisCreep)-creepSpeed(thisCreep)
                if creepTime(thisCreep)<=0 then
                    creepTime(thisCreep)=100
                    if creepPosX(thisCreep)=0 then
                        creepPosX(thisCreep)=pathX(1) : creepPosY(thisCreep)=pathY(1)
                        if thisCreep >1 then #td.main "spriteXY creep";thisCreep;" ";(creepPosX(thisCreep)-1)*20+3;" ";(creepPosY(thisCreep)-1)*20+4
                        if compteurBOSS = 0 and thisCreep = 1 then #td.main "spriteXY creep";thisCreep;" ";(creepPosX(thisCreep)-1)*20+1;" ";(creepPosY(thisCreep)-1)*20-8;"; spritetofront creep";thisCreep;""
                        if compteurSUPERboss = 0 and thisCreep = 1 then #td.main "spriteXY creep";thisCreep;" ";(creepPosX(thisCreep)-1)*20+1;" ";(creepPosY(thisCreep)-1)*20-8;"; spritetofront creep";thisCreep;""
                        if compteurBOSS > 0 and compteurSUPERboss > 0 and thisCreep = 1 then #td.main "spriteXY creep";thisCreep;" ";(creepPosX(thisCreep)-1)*20+5;" ";(creepPosY(thisCreep)-1)*20+4
                        exit sub
                    end if
                    if creepPosX(thisCreep)>0 then
                        for index = 1 to 69
                            if creepPosX(thisCreep)=pathX(index) AND creepPosY(thisCreep)=pathY(index) then exit for
                        next index
                        if index>68 then life = life - 1 : NumberSprite = NumberSprite - 1 : creepPosX(thisCreep)=0 : creepPosY(thisCreep)=0 : creepHealth(thisCreep)=0
                        if index<=68 then creepPosX(thisCreep)=pathX(index+1) : creepPosY(thisCreep)=pathY(index+1)
                        if thisCreep >1 then
                            #td.main "spriteXY creep";thisCreep;" ";(creepPosX(thisCreep)-1)*20+5;" ";(creepPosY(thisCreep)-1)*20+4
                            else
                                select case compteurSUPERboss
                                    case 0
                                        #td.main "spriteXY creep";thisCreep;" ";(creepPosX(thisCreep)-1)*20+1;" ";(creepPosY(thisCreep)-1)*20-8;"; spritetofront creep";thisCreep;""
                                    case else
                                        if compteurBOSS = 0 then #td.main "spriteXY creep";thisCreep;" ";(creepPosX(thisCreep)-1)*20+1;" ";(creepPosY(thisCreep)-1)*20-8;"; spritetofront creep";thisCreep;""
                                        if compteurBOSS > 0 then #td.main "spriteXY creep";thisCreep;" ";(creepPosX(thisCreep)-1)*20+3;" ";(creepPosY(thisCreep)-1)*20+4
                                end select
                        end if
                    end if
                end if
            end if
        next thisCreep
        for t = 1 to towers
            on error goto [nextTower]
            if towerTime(t)<=0 then
                for c = 1 to maxCreeps
                    if creepHealth(c)<=0 then goto [nextCreep]
                    cx=creepPosX(c) : cy=creepPosY(c) : tx=towerX(t) : ty=towerY(t) : dist = sqr( abs(tx-cx)*abs(tx-cx) + abs(ty-cy)*abs(ty-cy) )
                    if dist<towerRange(t) then
                        r$ = mcisend$("pause laser")
                        x = (tx-1) * 20 : y = (ty-1) * 20 : cx = (cx-1) * 20 +5 : cy = (cy-1) * 20 +5
                        #td.main "spritevisible bulletX";tx;"Y";ty;" on"
                        while (x>cx+3 or x<cx-3) and (y>cy+3 or y<cy-3)
                            #td.main "spritexy bulletX";tx;"Y";ty;" ";x;" ";y : #td.main "drawsprites"
                            if x<cx-1 then x=x+1
                            if x>cx+1 then x=x-1
                            if y<cy-1 then y=y+1
                            if y>cy+1 then y=y-1
                        wend
                        #td.main "spritevisible bulletX";tx;"Y";ty;" off"
                        creepHealth(c)=creepHealth(c)-towerDamage(t) : towerTime(t)=100
                        if bruitage = 1 then r$ = mcisend$("play laser from 0")
                        if creepHealth(c)<=0 then
                            #td.main "removesprite creep";c
                            NumberSprite = NumberSprite - 1 : ENNEMIgold = int(rnd(1)*int(1+(Nvague/10))+1) : gold = gold +  ENNEMIgold
                            if c = 1 and compteurBOSS = 0 then life = life + 1 : gold = gold + (10*Nvague)
                            if c = 1 and compteurSUPERboss = 0 then life = life + 3 : gold = gold + (30*Nvague)
                        end if
                        exit for
                    end if
                    [nextCreep]
                next c
            else
                towerTime(t)=towerTime(t)-towerSpeed(t)
            end if
            [nextTower]
        next t
    end sub

    sub placeTower1 x, y
        map$=mid$(map$,1,x+(y-1)*22-1) ; "!" ; mid$(map$, x+(y-1)*22+1) : towers=towers+1
        towerX(towers)=x
        towerY(towers)=y
        towerSpeed(towers)=4
        towerRange(towers)=2
        towerDamage(towers)=10
        towerTime(towers)=100
        #td.main "addsprite towerX";x;"Y";y;" towerA towerA; spritexy towerX";x;"Y";y;" ";(x-1)*20;" ";(y-1)*20
        bulletX(towers) = x : bulletY(towers) = y
        #td.main "addsprite bulletX";x;"Y";y;" bullet bullet; spritexy bulletX";x;"Y";y;" ";(x-1)*20+5;" ";(y-1)*20+1 : #td.main "spritevisible bulletX";x;"Y";y;" off"
    end sub
    sub placeTower2 x, y
        map$=mid$(map$,1,x+(y-1)*22-1) ; "#" ; mid$(map$, x+(y-1)*22+1) : towers=towers+1
        towerX(towers)=x
        towerY(towers)=y
        towerSpeed(towers)=5
        towerRange(towers)=2
        towerDamage(towers)=25
        towerTime(towers)=100
        #td.main "addsprite towerX";x;"Y";y;" towerB towerB; spritexy towerX";x;"Y";y;" ";(x-1)*20;" ";(y-1)*20
        bulletX(towers) = x : bulletY(towers) = y
        #td.main "addsprite bulletX";x;"Y";y;" bullet bullet; spritexy bulletX";x;"Y";y;" ";(x-1)*20+5;" ";(y-1)*20+1 : #td.main "spritevisible bulletX";x;"Y";y;" off"
    end sub
    sub placeTower3 x, y
        map$=mid$(map$,1,x+(y-1)*22-1) ; "$" ; mid$(map$, x+(y-1)*22+1) : towers=towers+1
        towerX(towers)=x
        towerY(towers)=y
        towerSpeed(towers)=5
        towerRange(towers)=2
        towerDamage(towers)=50
        towerTime(towers)=100
        #td.main "addsprite towerX";x;"Y";y;" towerC; spritexy towerX";x;"Y";y;" ";(x-1)*20;" ";(y-1)*20
        bulletX(towers) = x : bulletY(towers) = y
        #td.main "addsprite bulletX";x;"Y";y;" bullet bullet; spritexy bulletX";x;"Y";y;" ";(x-1)*20+5;" ";(y-1)*20+1 : #td.main "spritevisible bulletX";x;"Y";y;" off"
    end sub
    sub placeTower4 x, y
        map$=mid$(map$,1,x+(y-1)*22-1) ; "%" ; mid$(map$, x+(y-1)*22+1) : towers=towers+1
        towerX(towers)=x
        towerY(towers)=y
        towerSpeed(towers)=6
        towerRange(towers)=2
        towerDamage(towers)=100
        towerTime(towers)=100
        #td.main "addsprite towerX";x;"Y";y;" towerD; spritexy towerX";x;"Y";y;" ";(x-1)*20;" ";(y-1)*20
        bulletX(towers) = x : bulletY(towers) = y
        #td.main "addsprite bulletX";x;"Y";y;" bullet bullet; spritexy bulletX";x;"Y";y;" ";(x-1)*20+5;" ";(y-1)*20+1 : #td.main "spritevisible bulletX";x;"Y";y;" off"
    end sub
    sub placeTower5 x, y
        map$=mid$(map$,1,x+(y-1)*22-1) ; "(" ; mid$(map$, x+(y-1)*22+1) : towers=towers+1
        towerX(towers)=x
        towerY(towers)=y
        towerSpeed(towers)=6
        towerRange(towers)=3
        towerDamage(towers)=200
        towerTime(towers)=100
        #td.main "addsprite towerX";x;"Y";y;" towerE; spritexy towerX";x;"Y";y;" ";(x-1)*20;" ";(y-1)*20
        bulletX(towers) = x : bulletY(towers) = y
        #td.main "addsprite bulletX";x;"Y";y;" bullet bullet; spritexy bulletX";x;"Y";y;" ";(x-1)*20+5;" ";(y-1)*20+1 : #td.main "spritevisible bulletX";x;"Y";y;" off"
    end sub
    sub placeTower6 x, y
        map$=mid$(map$,1,x+(y-1)*22-1) ; ")" ; mid$(map$, x+(y-1)*22+1) : towers=towers+1
        towerX(towers)=x
        towerY(towers)=y
        towerSpeed(towers)=7
        towerRange(towers)=3
        towerDamage(towers)=400
        towerTime(towers)=100
        #td.main "addsprite towerX";x;"Y";y;" towerF; spritexy towerX";x;"Y";y;" ";(x-1)*20;" ";(y-1)*20
        bulletX(towers) = x : bulletY(towers) = y
        #td.main "addsprite bulletX";x;"Y";y;" bullet bullet; spritexy bulletX";x;"Y";y;" ";(x-1)*20+5;" ";(y-1)*20+1 : #td.main "spritevisible bulletX";x;"Y";y;" off"
    end sub
    sub placeTower7 x, y
        map$=mid$(map$,1,x+(y-1)*22-1) ; "*" ; mid$(map$, x+(y-1)*22+1) : towers=towers+1
        towerX(towers)=x
        towerY(towers)=y
        towerSpeed(towers)=8
        towerRange(towers)=3
        towerDamage(towers)=1000
        towerTime(towers)=100
        #td.main "addsprite towerX";x;"Y";y;" towerG; spritexy towerX";x;"Y";y;" ";(x-1)*20;" ";(y-1)*20
        bulletX(towers) = x : bulletY(towers) = y
        #td.main "addsprite bulletX";x;"Y";y;" bullet bullet; spritexy bulletX";x;"Y";y;" ";(x-1)*20+5;" ";(y-1)*20+1 : #td.main "spritevisible bulletX";x;"Y";y;" off"
    end sub
    sub placeTower8 x, y
        map$=mid$(map$,1,x+(y-1)*22-1) ; "+" ; mid$(map$, x+(y-1)*22+1) : towers=towers+1
        towerX(towers)=x
        towerY(towers)=y
        towerSpeed(towers)=8
        towerRange(towers)=3
        towerDamage(towers)=2000
        towerTime(towers)=100
        #td.main "addsprite towerX";x;"Y";y;" towerH towerH; spritexy towerX";x;"Y";y;" ";(x-1)*20;" ";(y-1)*20
        bulletX(towers) = x : bulletY(towers) = y
        #td.main "addsprite bulletX";x;"Y";y;" bullet bullet; spritexy bulletX";x;"Y";y;" ";(x-1)*20+5;" ";(y-1)*20+1 : #td.main "spritevisible bulletX";x;"Y";y;" off"
    end sub
    sub placeTower9 x, y
        map$=mid$(map$,1,x+(y-1)*22-1) ; "," ; mid$(map$, x+(y-1)*22+1) : towers=towers+1
        towerX(towers)=x
        towerY(towers)=y
        towerSpeed(towers)=9
        towerRange(towers)=4
        towerDamage(towers)=4000
        towerTime(towers)=100
        #td.main "addsprite towerX";x;"Y";y;" towerI; spritexy towerX";x;"Y";y;" ";(x-1)*20;" ";(y-1)*20
        bulletX(towers) = x : bulletY(towers) = y
        #td.main "addsprite bulletX";x;"Y";y;" bullet bullet; spritexy bulletX";x;"Y";y;" ";(x-1)*20+5;" ";(y-1)*20+1 : #td.main "spritevisible bulletX";x;"Y";y;" off"
    end sub
    sub placeTower10 x, y
        map$=mid$(map$,1,x+(y-1)*22-1) ; "" ; mid$(map$, x+(y-1)*22+1) : towers=towers+1
        towerX(towers)=x
        towerY(towers)=y
        towerSpeed(towers)=10
        towerRange(towers)=4
        towerDamage(towers)=8000
        towerTime(towers)=100
        #td.main "addsprite towerX";x;"Y";y;" towerJ; spritexy towerX";x;"Y";y;" ";(x-1)*20;" ";(y-1)*20
        bulletX(towers) = x : bulletY(towers) = y
        #td.main "addsprite bulletX";x;"Y";y;" bullet bullet; spritexy bulletX";x;"Y";y;" ";(x-1)*20+5;" ";(y-1)*20+1 : #td.main "spritevisible bulletX";x;"Y";y;" off"
    end sub

    Sub Sleep ms
        CallDLL #kernel32, "Sleep",_
        ms as long,_
        ret as void
    End Sub

    sub AddToolTip cHndl, hWnd, Text$ 
        TOOLINFO.uId.struct = cHndl
        TOOLINFO.lpszText.struct = Text$
        CallDLL #user32, "SendMessageA",hWnd As long,1028 As long, _
        0 As long,TOOLINFO as ptr,ret As long
    end sub

    sub RemooveOldTower x, y
    if UPGRADE = 0 then towers = 0 : map$=mid$(map$,1,x+(y-1)*22-1) ; " " ; mid$(map$, x+(y-1)*22+1)
    if UPGRADE = 1 then towerOLD = towers
    for x = 1 to 22
        for y = 1 to 18
            char$ = mid$(map$, x+(y-1)*22, 1)
            select case char$
                case "!"
                    call placeTower1 x, y
                case "#"
                    call placeTower2 x, y
                case "$"
                    call placeTower3 x, y
                case "%"
                    call placeTower4 x, y
                case "("
                   call placeTower5 x, y
                case ")"
                   call placeTower6 x, y
                case "*"
                   call placeTower7 x, y
                case "+"
                   call placeTower8 x, y
                case ","
                   call placeTower9 x, y
                case ""
                   call placeTower10 x, y
            end select
        next y
    next x
    if UPGRADE = 1 then towers = towers - towerOLD
    end sub


    ' FUNCTIONS --------------------------------------------------------------------------------------------


    function mcisend$(s$)
        buffer$=space$(256)+chr$(0)
        calldll #winmm,"mciSendStringA",s$ as ptr,buffer$ as ptr, 256 as long,0 as long,r as long
        if r>0 then
            mcisend$="error r="+str$(r)+" "+buffer$
        else
            mcisend$=buffer$
        end if
    end function

    Function CreateTooltip(hMain)
        Struct TOOLINFO, _
        cbSize As long, _
        uFlags As long, _
        hwnd As long, _
        uId As long, _
        rectLeft As long, _
        rectTop As long, _
        rectRight As long, _
        rectBottom As long, _
        hinst As long, _
        lpszText As ptr
        CallDLL #comctl32,"InitCommonControlsEx", _
        ret As void
        TOOLINFO.cbSize.struct = Len(TOOLINFO.struct)
        TOOLINFO.uFlags.struct = flags Or 17 'TTF_IDISHWND Or TTF_SUBCLASS
        TOOLINFO.hwnd.struct = hMain
        CallDLL #user32,"CreateWindowExA",_
        0 As long, _
        "tooltips_class32" As ptr, _
        0 As long, style As long, _
        _CW_USEDEFAULT As long, _
        _CW_USEDEFAULT As long, _
        _CW_USEDEFAULT As long, _
        _CW_USEDEFAULT As long, _
        hMain As long, _
        0 As long, _
        0 as long, _
        0 As long, _
        CreateTooltip As Long
    end function

    function fileExist(dir$,file$)
        dim info$(10, 10)
        files dir$,file$, info$(
        if val(info$(0, 0)) > 0 then
            fileExist = 1
        else
            fileExist = 0
        end if
    end function


